<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitContactGroups\Modals;


use BplanModules\VisitorManagement\Models\VisitContactGroup;
// use BplanModules\VisitorManagement\Services\VisitContactGroupService;
use BplanModules\VisitorManagement\Services\VisitContactGroupService;
use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use Illuminate\Database\Eloquent\Collection;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Edit extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var VisitContactGroup|null
     */
    public ?VisitContactGroup $contactGroup;


    /**
     * Undocumented variable
     *
     * @var VisitContactGroupService
     */
    protected VisitContactGroupService $contactGroupService;


    /**
     *
     * @var boolean
     */
    public bool $isActive = false;


    /**
     *
     * @var array|null
     */
    #[Rule('required')]
    public ?array $labelsJson;


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitContactGroupService $contactGroupService)
    {
        $this->logService = $logService;
        $this->contactGroupService = $contactGroupService;

    } // boot()


    // /**
    //  *
    //  * @version     1.0.0 / 2025-04-13
    //  * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
    //  * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
    //  */
    // public function deleteContactGroup()
    // {
    //     try
    //     {
    //         $this->contactGroupService->delete($this->contactGroup->id);

    //         $this->dispatch('contact-group-deleted');
    //     } catch (\Throwable $th) {
    //         $this->logService->log(LogLevel::Error, 'ContactGroups/Modals/deleteContactGroup error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
    //         $this->dangerBanner('Error when deleting contact group. Check the logs for more information.');
    //     }
    // } // deleteContactGroup()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function editContactGroup()
    {
        $this->validate();

        try {
            $this->contactGroupService->update($this->contactGroup->id, [
                'labels' => $this->labelsJson,
                'active' => $this->isActive,
            ]);

            $this->logService->log(LogLevel::Info, "ContactGroup edited by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('contact-group-edited');

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'ContactGroups/Modals/editContactGroup error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing ContactGroup. Check the logs for more information.');
        }
    } // editContactGroup()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('show-edit-contact-group-modal')]
    public function initContactGroup(VisitContactGroup $contactGroup)
    {
        $this->contactGroup = $contactGroup;

        $this->isActive = $contactGroup->active;
        $this->labelsJson = (array)$contactGroup->labels;

    } // initContactGroup()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        //
    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('multi-language-json-created')]
    public function onMultiLanguageJsonCreated(?array $json, string $target)
    {
        if ($target == 'edit') {
            $this->labelsJson = $json;
        }
    } // onMultiLanguageJsonCreated()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        //  ToDoToDo
        // return view('livewire.contact-groups.modals.edit-contact-group');
        // return view('livewire.contact-groups.modals.edit');
        return view('visitor-management::livewire.visit-contact-groups.modals.edit');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->labelsJson = [];

    } // resetModal()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Edit extends Component {}
