<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitEmployees\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Models\VisitEmployee;
use BplanModules\VisitorManagement\Repositories\VisitAppointmentRepository;
use BplanModules\VisitorManagement\Services\VisitEmployeeService;
use BplanModules\VisitorManagement\Traits\WithLicensePlateInput;
use Illuminate\Database\Eloquent\Collection;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Attributes\Validate;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Edit extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;
    use WithLicensePlateInput;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var Collection|null
     */
    public ?Collection $accessAuthorizations;


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $contactGroup;


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $department;


    /**
     *
     * @var string|null
     */
    #[Validate('required|email:rfc,dns')]
    public ?string $email;


    /**
     *
     * @var VisitEmployee|null
     */
    public ?VisitEmployee $employee;


    /**
     *
     * @var VisitEmployeeService
     */
    protected VisitEmployeeService $employeeService;


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $firstname;


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $function;


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $lastname;


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


    /**
     *
     * @var string|null
     */
    #[Validate('required|phone:INTERNATIONAL')]
    public ?string $mobilenumber;


    /**
     *
     * @var string|null
     */
    #[Validate('required|phone:INTERNATIONAL')]
    public ?string $phonenumber;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitEmployeeService $employeeService)
    {
        $this->logService = $logService;
        $this->employeeService = $employeeService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function editEmployee()
    {
        $this->validate();

        try {
            $this->employeeService->update($this->employee->id, [
                'first_name' => $this->firstname,
                'last_name' => $this->lastname,
                'email' => $this->email,
                'mobile_phone_number' => $this->mobilenumber,
                'phone_number' => $this->phonenumber,
                'department' => $this->department,
                'function' => $this->function,
                'contact_group' => $this->contactGroup,
                'license_plate' => implode(';', $this->licensePlates),
            ]);

            $this->logService->log(LogLevel::Info, "Emplyoee {$this->firstname}, {$this->lastname} edited by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('employee-edited');

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Locations/Modals/editEmployee error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing employee. Check the logs for more information.');
        }
    } // editEmployee()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('show-edit-employee-modal')]
    public function initEmployee(VisitEmployee $employee)
    {
        $this->employee = $employee;
        $this->accessAuthorizations = VisitAppointmentRepository::getEmployeeAccessAuthorizations($this->employee->id);

        $this->firstname = $employee->first_name;
        $this->lastname = $employee->last_name;
        $this->email = $employee->email;
        $this->mobilenumber = $employee->mobile_phone_number;
        $this->phonenumber = $employee->phone_number;
        $this->licensePlates = explode(';', $employee->license_plate);

        $this->dispatch('init-tippyjs');

    } // initEmployee()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        $this->accessAuthorizations = new Collection();

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-employees.modals.edit');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->clearLicensePlates();

        $this->employee = null;

        $this->firstname = null;
        $this->lastname = null;
        $this->email = null;
        $this->mobilenumber = null;
        $this->phonenumber = null;

    } // resetModal()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Edit extends Component {}
