<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitVisitors\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Enums\LanguageContext;
use BplanModules\VisitorManagement\Models\VisitLanguage;
use BplanModules\VisitorManagement\Services\VisitVisitorService;
use Illuminate\Database\Eloquent\Collection;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\Validate;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Create extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    //#[Validate('required')]
    //public ?string $birthday;
    //#[Validate('required')]
    //public ?string $country;
    //#[Validate('required')]
    //public ?string $postcode;
    //#[Validate('required')]
    //public ?string $street;
    //#[Validate('required')]
    //public ?string $housenumber;


    /**
     *
     * @var string|null
     */
    public ?string $company = "";


    /**
     *
     * @var string|null
     */
    #[Validate('sometimes|email:rfc,dns')]
    public ?string $email = "";


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $firstname = "";


    /**
     *
     * @var boolean|null
     */
    public ?bool $hasSafetyBriefing = false;


    /**
     *
     * @var array|null
     */
    public ?array $languages = [];


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $lastname = "";


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


    /**
     *
     * @var string|null
     */
    #[Validate('sometimes|phone:INTERNATIONAL')]
    public ?string $mobilenumber = "";


    /**
     *
     * @var string|null
     */
    public ?string $mobilenumberDialCode = "";


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $preferredLanguage = "";


    /**
     *
     * @var VisitVisitorService
     */
    protected VisitVisitorService $visitorService;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitVisitorService $visitorService)
    {
        $this->logService = $logService;
        $this->visitorService = $visitorService;
        $this->languages = VisitLanguage::where('context', '&', LanguageContext::Both->value)->get()->pluck('code')->toArray();

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function createVisitor()
    {
        $this->validate();

        $this->mobilenumberDialCode = "+{$this->mobilenumberDialCode}";
        $this->mobilenumber = str_replace($this->mobilenumberDialCode, '', $this->mobilenumber);

        try {
            $this->visitorService->create([
                'verified' => true,
                'first_name' => $this->firstname,
                'last_name' => $this->lastname,
                'email' => $this->email,
                'mobile_phone_number' => $this->mobilenumber,
                'mobile_phone_number_country_code' => $this->mobilenumberDialCode,
                'company' => $this->company,
                'preferred_language' => $this->preferredLanguage,
                // 'birthday' => $this->birthday,
                // 'country' => $this->country,
                // 'zip' => $this->postcode,
                // 'street' => $this->street,
                // 'housenumber' => $this->housenumber,
                // 'hasSafetyBriefing' => $this->hasSafetyBriefing,
            ]);

            $this->logService->log(LogLevel::Info, "Visitor {$this->firstname}, {$this->lastname} added by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('visitor-created');

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Locations/Modals/createVisitor error createVisitor: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when creating visitor. Check the logs for more information.');
        }
    } // createVisitor()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        $this->preferredLanguage = config('app.fallback_locale');

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-visitors.modals.create');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->firstname = null;
        $this->lastname = null;
        $this->email = null;
        $this->mobilenumber = null;
        $this->company = null;
        $this->preferredLanguage = config('app.fallback_locale');

        // $this->birthday = null;
        // $this->country = null;
        // $this->postcode = null;
        // $this->street = null;
        // $this->housenumber = null;
        $this->hasSafetyBriefing = false;

    } // resetModal()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Create extends Component {}
