<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitVisitors\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Enums\ImportContext;
use BplanModules\VisitorManagement\Imports\VisitorsImport;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;



/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Upload extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use WithFileUploads;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var array
     */
    public array $errors = [];


    /**
     *
     * @var array
     */
    public array $failures = [];


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


    /**
     *
     * @var string|null
     */
    public ?string $importSuccessMessage;


    /**
     *
     * @var [type]
     */
    public $visitorsFile;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService)
    {
        $this->logService = $logService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('show-upload-visitors-modal')]
    public function init()
    {
        //
    } // init()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-visitors.modals.upload');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->visitorsFile = null;
        $this->importSuccessMessage = null;

        $this->errors = [];
        $this->failures = [];

        $this->resetErrorBag();

    } // resetModal()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function uploadVisitors()
    {
        $import = new VisitorsImport(ImportContext::Upload);
        $this->resetErrorBag();

        try {
            if (isset($this->visitorsFile)) {
                $this->logService->log(LogLevel::Info, "Starting direct-import.");
                $result = $import->importFile($this->visitorsFile->getRealPath());
                $this->logService->log(LogLevel::Info, "Direct-Import finished.");

                $this->importSuccessMessage = trans('visitor-management::personalization.visitors_imported_successfully', ['count' => $import->getRowCountSaved()]);
                $this->dispatch('visitors-upload-finished');
            }
        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Visitors/Modals/uploadVisitors error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());

            $this->failures = (array)json_decode(json_encode($import->getFailures())); //liefert die Fehler die auf fehlerhaften Daten (z.B. fehlende Pflichtangaben oder ungültige Mail-Adressen) hinweisen.
            $this->errors = (array)json_decode(json_encode($import->getErrors())); //liefert Fehler die beim Versuch einen Datensatz zu speichern aufgetreten sind.
            // TODO LOG ERROR
            $this->addError('visitorsFile', trans('visitor-management::personalization.error_while_importing'));
        }
    } // uploadVisitors()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Upload extends Component {}
