<?php

namespace BplanModules\VisitorManagement\Livewire\VisitVisitors\Personalize\Modals;

use Livewire\Attributes\Validate;
use Livewire\Component;

class Create extends Component
{
    #[Validate('required')]
    public ?string $firstname;
    #[Validate('required')]
    public ?string $lastname;
    #[Validate('required|email:rfc,dns')]
    public ?string $email;
    #[Validate('required')]
    public ?string $mobilenumber;
    #[Validate('required|accepted')]
    public ?bool $isMobilenumberValid = false;
    #[Validate('required')]
    public ?string $company;
    // #[Validate('required')]
    // public ?string $birthday;
    // #[Validate('required')]
    // public ?string $country;
    // #[Validate('required')]
    // public ?string $postcode;
    // #[Validate('required')]
    // public ?string $street;
    // #[Validate('required')]
    // public ?string $housenumber;

    public function render()
    {
        return view('visitor-management::livewire.visit-visitors.personalize.modals.create');
    }

    public function resetModal()
    {
        $this->firstname = null;
        $this->lastname = null;
        $this->email = null;
        $this->mobilenumber = null;
        $this->company = null;
        $this->isMobilenumberValid = false;
        // $this->birthday = null;
        // $this->country = null;
        // $this->postcode = null;
        // $this->street = null;
        // $this->housenumber = null;
        // $this->hasSafetyBriefing = false;
    }

    public function addVisitor()
    {
        $this->validate();

        $visitor = [
            'first_name' => $this->firstname,
            'last_name' => $this->lastname,
            'email' => $this->email,
            'mobile_phone_number' => $this->mobilenumber,
            'company' => $this->company,
        ];

        $this->dispatch('visitor-added', visitor: $visitor);
    }
}
