<?php
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-20 19:05:57
 * @package     bplan-modules/visitor-management
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Models;


use App\Models\User;
use BplanBase\Globals\Traits\HasActiveScope;
use BplanBase\Globals\Traits\HasOrderedScope;
use BplanModules\VisitorManagement\Enums\TokenPrefix;
use BplanModules\VisitorManagement\Models\VisitEmployee;
use BplanModules\VisitorManagement\Models\VisitEquipmentItem;
use BplanModules\VisitorManagement\Observers\VisitAppointmentObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;
use Illuminate\Database\Eloquent\SoftDeletes;


/**
 * Model Class
 *
 * @version     1.5.0 / 2025-05-25
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([VisitAppointmentObserver::class])]
class VisitAppointment extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasActiveScope;
    use HasOrderedScope;
    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Präfix für das Token
     *
     * "W" für Web.
     *
     * @var     string WEB_TOKEN_PREFIX
     */
    const WEB_TOKEN_PREFIX = TokenPrefix::Web->value;


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-04-20
     */
    protected $appends = [];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-04-20
     */
    protected $casts = [
        'active'                  => 'boolean',
        'bulk_informations'       => 'object',
        'called_in_at'            => 'datetime',
        'checked_in_at'           => 'datetime',
        'checked_out_at'          => 'datetime',
        'created_at'              => 'datetime',
        'deleted_at'              => 'datetime',
        'drive_on_area_permitted' => 'boolean',
        'entered_at'              => 'datetime',
        'finished_at'             => 'datetime',
        'internal_visit'          => 'boolean',
        'require_escort'          => 'boolean',
        'spontaneous_visit'       => 'boolean',
        'updated_at'              => 'datetime',
        'valid_from'              => 'datetime',
        'valid_until'             => 'datetime',
        'visitors'                => 'object',
        'with_minors'             => 'boolean',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-04-20
     */
    protected $fillable = [
        'active',
        'bulk_appointment_id',
        'bulk_informations',
        'check_in_entry_point_id',
        'check_out_entry_point_id',
        'drive_on_area_permitted',
        'ews_appointment_id',
        'internal_visit',
        'license_plate_formatted',
        'loading_ramp_id',
        'main_employee_id',
        'main_visitor_id',
        'order_number',
        'organizer_employee_id',
        'require_escort',
        'spontaneous_visit',
        'subject',
        'valid_from',
        'valid_until',
        'visit_reason_id',
        'visitors',
        'with_minors',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-04-20
     */
    protected $guarded = [
        'called_in_at',
        'checked_in_at',
        'checked_out_at',
        'create_user_id',
        'created_at',
        'deleted_at',
        'entered_at',
        'finished_at',
        'license_plate',
        'process_status',
        'token',
        'updated_at',
        'uuid',
        'web_token',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-04-20
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'visit_appointments';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function bulkAppointment(): BelongsTo
    {
        return $this->belongsTo(VisitAppointment::class, 'bulk_appointment_id');

    } // bulkAppointment()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function bulkAppointments(): HasMany
    {
        return $this->hasMany(VisitAppointment::class, 'bulk_appointment_id');

    } // bulkAppointments()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function checkInEntryPoint(): BelongsTo
    {
        return $this->belongsTo(VisitEntryPoint::class, 'check_in_entry_point_id');

    } // checkInEntryPoint()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function checkOutEntryPoint(): BelongsTo
    {
        return $this->belongsTo(VisitEntryPoint::class, 'check_out_entry_point_id');

    } // checkOutEntryPoint()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function createUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'create_user_id');

    } // createUser()


    /**
     *
     * @return      BelongsToMany
     *
     * @version     1.0.1 / 2024-10-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function employees(): BelongsToMany
    {
        return $this->belongsToMany(VisitEmployee::class);

    } // employees()


    /**
     *
     * @return      BelongsToMany
     *
     * @version     1.0.0 / 2024-10-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function equipmentItems(): BelongsToMany
    {
        return $this->belongsToMany(VisitEquipmentItem::class, 'visit_appointment_equipment_item', 'equipment_item_id', 'appointment_id')->withPivot('amount');

    } // equipmentItems()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function loadingRamp(): BelongsTo
    {
        return $this->belongsTo(VisitLocation::class, 'loading_ramp_id');

    } // loadingRamp()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mainEmployee(): BelongsTo
    {
        return $this->belongsTo(VisitEmployee::class, 'main_employee_id');

    } // mainEmployee()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mainVisitor(): BelongsTo
    {
        return $this->belongsTo(VisitVisitor::class, 'main_visitor_id');

    } // mainVisitor()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function organizerEmployee(): BelongsTo
    {
        return $this->belongsTo(VisitEmployee::class, 'organizer_employee_id');

    } // organizerEmployee()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function statusLogs(): HasMany
    {
        return $this->hasMany(VisitAppointmentStatusLog::class, 'appointment_id');

    } // statusLogs()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function visitReason(): BelongsTo
    {
        return $this->belongsTo(VisitReason::class, 'visit_reason_id');

    } // visitReason()


    /**
     * Liefert den VisitType über den VisitReason des Appointments
     *
     * Die Methode kann nicht verwendet werden um die Relation für die JSON:API verfügbar zu machen,
     * weil $this->visitReason in dem Kontext immer NULL ist.
     * Der umgekehrte Weg (VisitType::appointments()) funktioniert mit der JSON:API.
     *
     * @return      BelongsTo
     *
     * @version     1.0.1 / 2024-09-23
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function visitType(): HasOneThrough
    {
        return $this->hasOneThrough(
            VisitType::class,
            VisitReason::class,
            'id', // Fremdschlüssel in der VisitReason-Tabelle
            'id', // Fremdschlüssel in der VisitType-Tabelle
            'visit_reason_id', // Lokaler Fremdschlüssel in der Appointment-Tabelle
            'visit_type_id' // Fremdschlüssel in der VisitReason-Tabelle
        );
    } // visitType()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitAppointment extends Model {}
