<?php
/**
 * Model Class
 *
 * Aus der dynamischen Erzeugung genommen wegen der Notification-Methoden.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-21 22:26:12
 * @package     bplan-modules/visitor-management
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Models;


use App\Models\User;
use BplanBase\Globals\Traits\HasActiveScope;
use BplanBase\Globals\Traits\HasOrderedScope;
use BplanModules\VisitorManagement\Observers\VisitEmployeeObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Illuminate\Notifications\Notification;


/**
 * Model Class
 *
 * @version     1.5.0 / 2025-05-25
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([VisitEmployeeObserver::class])]
class VisitEmployee extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasActiveScope;
    use HasOrderedScope;
    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $appends = [];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $casts = [
        'active'            => 'boolean',
        'contact'           => 'boolean',
        'created_at'        => 'datetime',
        'deleted_at'        => 'datetime',
        'emergency_contact' => 'boolean',
        'global_contact'    => 'boolean',
        'import_failures'   => 'object',
        'updated_at'        => 'datetime',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $fillable = [
        'active',
        'contact',
        'contact_group_id',
        'department',
        'email',
        'emergency_contact',
        'first_name',
        'function',
        'global_contact',
        'import_failure_count',
        'import_failures',
        'last_name',
        'license_plate',
        'mobile_phone_number',
        'mobile_phone_number_country_code',
        'personnel_number',
        'phone_number',
        'phone_number_country_code',
        'user_id',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $guarded = [
        'created_at',
        'deleted_at',
        'updated_at',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'visit_employees';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      BelongsToMany
     *
     * @version     1.0.0 / 2025-04-21
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function appointments(): BelongsToMany
    {
        return $this->belongsToMany(VisitAppointment::class, 'visit_appointment_employee', 'appointment_id', 'employee_id');

    } // appointments()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-04-21
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function assignedAppointments(): HasMany
    {
        return $this->hasMany(VisitAppointment::class, 'main_employee_id');

    } // assignedAppointments()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-21
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function contactGroup(): BelongsTo
    {
        return $this->belongsTo(VisitContactGroup::class, 'contact_group_id');

    } // contactGroup()


    /**
     *
     * @param       bool $reverted
     *
     * @return 	    string
     *
     * @version     2.0.0 / 2025-02-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getFullName(bool $reverted = false): string
    {
        if ($reverted === true) {
            return $this->last_name.', '.$this->first_name;
        }
        return $this->first_name.' '.$this->last_name;

    } // getFullName()


    /**
     *
     * @param       bool $getMobile
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2025-02-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPhoneNumber(bool $getMobile = false): null|string
    {
        if ($getMobile === true) {
            if ($this->mobile_phone_number === null) {
                return null;
            }
            return $this->mobile_phone_number_country_code.$this->mobile_phone_number;
        }
        if ($this->phone_number === null) {
            return null;
        }
        return $this->phone_number_country_code.$this->phone_number;

    } // getPhoneNumber()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-04-21
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function organizedAppointments(): HasMany
    {
        return $this->hasMany(VisitAppointment::class, 'organizer_employee_id');

    } // organizedAppointments()


    /**
     * Route notifications for the mail channel.
     *
     * @param       Notification $Notification
     *
     * @return      array<string, string>|null|string
     *
     * @version     1.1.0 / 2025-03-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function routeNotificationForMail(Notification $Notification): array|null|string
    {
        if ($this->email === null) {
            return null;
        }
        return [$this->email => $this->getFullName()];

    } // routeNotificationForMail()


    /**
     * Route notifications for the Spyng SMS channel.
     *
     * @return 	    null|string
     *
     * @version     1.3.0 / 2025-03-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function routeNotificationForSpryngSms(): null|string
    {
        if ($this->mobile_phone_number === null) {
            return null;
        }
        return str_replace(['+', ' ', '/', '-'], '', $this->getPhoneNumber(getMobile: true));

    } // routeNotificationForSpryngSms()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-21
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');

    } // user()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitEmployee extends Model {}
