<?php
/**
 * Observer Class
 *
 * Aus der automatischen Generierung genommen wegen der Token-Funktionalität.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-20 12:02:14
 * @package     bplan-modules/visitor-management
 * @subpackage  Observers
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Observers;


use BplanBase\Globals\Helpers\StringHelper;
use BplanModules\VisitorManagement\Enums\ProcessStatus;
use BplanModules\VisitorManagement\Enums\TokenPrefix;
use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Services\VisitAppointmentStatusLogService;
use BplanModules\VisitorManagement\Traits\HasToken;
use Illuminate\Support\Str;


/**
 * Observer Class
 *
 * @version     1.1.0 / 2025-04-20
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitAppointmentObserver
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasToken;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string MODEL_CLASS
     */
    const MODEL_CLASS = VisitAppointment::class;


    /**
     * Gesamtlänge des Tokens
     *
     * @var     string TOKEN_LENGTH
     */
    const TOKEN_LENGTH = 7;


    /**
     * Präfix für das Token
     *
     * "A" für Appointment.
     *
     * @var     string TOKEN_PREFIX
     */
    const TOKEN_PREFIX = TokenPrefix::Appointment->value;


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Handle the Models "created" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function created(VisitAppointment $Model): void
    {
        $LogService = new VisitAppointmentStatusLogService();

        $LogService->create([
            'appointment_id' => $Model->id,
            'process_status' => ProcessStatus::Open->value,
        ]);
    } // created()


    /**
     * Handle the Models "creating" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function creating(VisitAppointment $Model): void
    {
        /*
        **  Automatische Werte erzeugen und setzen. */
        $Model->uuid = Str::uuid();
        $Model->create_user_id = auth()->user()->id;
        $Model->token = self::_generateUniqueToken();
        $Model->web_token = VisitAppointment::WEB_TOKEN_PREFIX.md5(serialize($Model));

        if (empty($Model->license_plate_formatted)) {
            $Model->license_plate_formatted = null;

        } else {
            $Model->license_plate_formatted = mb_strtoupper(trim($Model->license_plate_formatted));
        }
        $Model->license_plate = StringHelper::normalizeLicensePlate($Model->license_plate_formatted);

        if ($Model->visitType->identifier === VisitTypeIdentifier::AccessAuthorization->name) {
            /*
            **  Zufahrtsberechtigungen erhalten direkt den Status "CalledIn", weil dafür kein CheckIn
            **  am Terminal erforderlich ist. */
            $Model->process_status = ProcessStatus::CalledIn->value;
        }

    } // creating()


    /**
     * Handle the Models "deleted" event
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleted(VisitAppointment $Model): void
    {
        //
    } // deleted()


    /**
     * Handle the Models "deleting" event
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleting(VisitAppointment $Model): void
    {
        //
    } // deleting()


    /**
     * Handle the Models "forceDeleted" event
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleted(VisitAppointment $Model): void
    {
        //
    } // forceDeleted()


    /**
     * Handle the Models "forceDeleting" event
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleting(VisitAppointment $Model): void
    {
        //
    } // forceDeleting()


    /**
     * Handle the Models "replicating" event
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function replicating(VisitAppointment $Model): void
    {
        //
    } // replicating()


    /**
     * Handle the Models "restored" event
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restored(VisitAppointment $Model): void
    {
        //
    } // restored()


    /**
     * Handle the Models "restoring" event
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restoring(VisitAppointment $Model): void
    {
        //
    } // restoring()


    /**
     * Handle the Models "retrieved" event
     *
     * The retrieved event will dispatch when an existing model is retrieved
     * from the database.
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function retrieved(VisitAppointment $Model): void
    {
        //
    } // retrieved()


    /**
     * Handle the Models "saved" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saved(VisitAppointment $Model): void
    {
        //
    } // saved()


    /**
     * Handle the Models "saving" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saving(VisitAppointment $Model): void
    {
        //
    } // saving()


    /**
     * Handle the Models "trashed" event
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function trashed(VisitAppointment $Model): void
    {
        //
    } // trashed()


    /**
     * Handle the Models "updated" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updated(VisitAppointment $Model): void
    {
        //
    } // updated()


    /**
     * Handle the Models "updating" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       VisitAppointment $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updating(VisitAppointment $Model): void
    {
        if (empty($Model->license_plate_formatted)) {
            $Model->license_plate_formatted = null;
        } else {
            $Model->license_plate_formatted = mb_strtoupper(trim($Model->license_plate_formatted));
        }
        $Model->license_plate = StringHelper::normalizeLicensePlate($Model->license_plate_formatted);

    } // updating()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Sucht das übergebene Token in der Datenbank
     *
     * Es müssen nur die zukünftigen Termine überprüft werden. Ein Konflikt mit den Tokens der
     * vergangenen Termine stellt kein Problem dar.
     *
     * @param       string $token
     *
     * @return 	    bool
     *
     * @version     1.0.0 / 2025-02-15
     * @history     Appointment::_searchToken(), 1.1.1 / 2024-12-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private static function _searchToken(string $token): bool
    {
        return VisitAppointment::where('token', '=', $token)
            ->where('process_status', '<', ProcessStatus::Finished->value)
            ->exists();

    } // _searchToken()


} // class VisitAppointmentObserver {}
