<?php
/**
 * Observer Class
 *
 * Wegen individueller Anpassungen aus der automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-20 12:03:31
 * @package     bplan-modules/visitor-management
 * @subpackage  Observers
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Observers;


use BplanBase\Globals\Helpers\StringHelper;
use BplanModules\VisitorManagement\Models\VisitVisitor;


/**
 * Observer Class
 *
 * @version     1.1.0 / 2025-04-20
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitVisitorObserver
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string MODEL_CLASS
     */
    const MODEL_CLASS = VisitVisitor::class;


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Handle the Models "created" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function created(VisitVisitor $Model): void
    {
        //
    } // created()


    /**
     * Handle the Models "creating" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function creating(VisitVisitor $Model): void
    {
        if (!empty($Model->mobile_phone_number_country_code)) {
            $phoneNumber = $Model->mobile_phone_number_country_code.$Model->mobile_phone_number;
        } else {
            $phoneNumber = $Model->mobile_phone_number;
        }
        $mobilePhoneNumber = StringHelper::explodePhoneNumber(StringHelper::normalizePhoneNumber($phoneNumber));

        $Model->email = StringHelper::normalizeEmail($Model->email);
        $Model->mobile_phone_number = $mobilePhoneNumber['phone-number'];
        $Model->mobile_phone_number_country_code = $mobilePhoneNumber['country-code'];

    } // creating()


    /**
     * Handle the Models "deleted" event
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleted(VisitVisitor $Model): void
    {
        //
    } // deleted()


    /**
     * Handle the Models "deleting" event
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleting(VisitVisitor $Model): void
    {
        //
    } // deleting()


    /**
     * Handle the Models "forceDeleted" event
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleted(VisitVisitor $Model): void
    {
        //
    } // forceDeleted()


    /**
     * Handle the Models "forceDeleting" event
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleting(VisitVisitor $Model): void
    {
        //
    } // forceDeleting()


    /**
     * Handle the Models "replicating" event
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function replicating(VisitVisitor $Model): void
    {
        //
    } // replicating()


    /**
     * Handle the Models "restored" event
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restored(VisitVisitor $Model): void
    {
        //
    } // restored()


    /**
     * Handle the Models "restoring" event
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restoring(VisitVisitor $Model): void
    {
        //
    } // restoring()


    /**
     * Handle the Models "retrieved" event
     *
     * The retrieved event will dispatch when an existing model is retrieved
     * from the database.
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function retrieved(VisitVisitor $Model): void
    {
        //
    } // retrieved()


    /**
     * Handle the Models "saved" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saved(VisitVisitor $Model): void
    {
        //
    } // saved()


    /**
     * Handle the Models "saving" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saving(VisitVisitor $Model): void
    {
        //
    } // saving()


    /**
     * Handle the Models "trashed" event
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function trashed(VisitVisitor $Model): void
    {
        //
    } // trashed()


    /**
     * Handle the Models "updated" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updated(VisitVisitor $Model): void
    {
        //
    } // updated()


    /**
     * Handle the Models "updating" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       VisitVisitor $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updating(VisitVisitor $Model): void
    {
        if (!empty($Model->mobile_phone_number_country_code)) {
            $phoneNumber = $Model->mobile_phone_number_country_code.$Model->mobile_phone_number;
        } else {
            $phoneNumber = $Model->mobile_phone_number;
        }
        $mobilePhoneNumber = StringHelper::explodePhoneNumber(StringHelper::normalizePhoneNumber($phoneNumber));

        $Model->email = StringHelper::normalizeEmail($Model->email);
        $Model->mobile_phone_number = $mobilePhoneNumber['phone-number'];
        $Model->mobile_phone_number_country_code = $mobilePhoneNumber['country-code'];

    } // updating()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitVisitorObserver {}
