<?php
/**
 * Repository Class
 *
 * Wegen individueller Anpassungen aus der automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-04 00:00:00
 * @package     bplan-modules/visitor-management
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Repositories;


use App\Models\VisitOpeningHour as DerivedVisitOpeningHour;
use BplanBase\Globals\Foundation\Repositories\BaseRepository;
use BplanBase\Globals\ValueObjects\PaginateArgs;
use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitOpeningHour;
use BplanModules\VisitorManagement\Models\VisitType;
use Carbon\WeekDay;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;


/**
 * Repository Class
 *
 * @version     2.2.0 / 2025-06-04
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitOpeningHourRepository extends BaseRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_derivedModelClass
     */
    protected static $_derivedModelClass = DerivedVisitOpeningHour::class;


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass = VisitOpeningHour::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Returns a collection of models
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the
     *              method cache already contains a suitable entry. The storage of
     *              a value in the method cache is not affected by this parameter.
     *
     * @param       array|string|null $orderBy
     *              @see BplanBase\Globals\Helpers\QueryHelper::applyOrderBy() for
     *              details.
     *
     * @param       array|bool|int $paginate
     *              Can be either the number of elements, TRUE or an array. If
     *              TRUE is passed, the default number from the configuration is
     *              used. If an array is passed, then all known arguments for
     *              paginate() (columns, page, pageName, perPage, total) can be
     *              specified in it (all optional).
     *              @see https://api.laravel.com/docs/12.x/Illuminate/Database/Eloquent/Builder.html#method_paginate
     *
     * @param       Builder|null $Query
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @return      Collection|LengthAwarePaginator
     *
     * @version     3.0.0 / 2025-06-04
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAll(bool $ignoreCache = false, array|string|null $orderBy = null, array|bool|int $paginate = false, Builder|null $Query = null, bool $withInactive = false): Collection|LengthAwarePaginator
    {
        static $cache = [];

        $cacheKey = md5(json_encode(func_get_args()));

        if ($paginate !== false) {
            $ignoreCache = true;
        }
        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query ??= static::_newBaseQuery();

        static::_validateQueryModel($Query);

        if ($withInactive === false) {
            $Query->active();
        }
        $Query->ordered($orderBy);

        if ($paginate === false) {
            return $cache[$cacheKey] = $Query->get();
        }
        $PaginateArgs = PaginateArgs::from($paginate);

        return $Query->paginate(...$PaginateArgs->toArray());

    } // getAll()


    /**
     * Returns the model instance for the given ID
     *
     * @param       int|string $id
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      VisitOpeningHour|DerivedVisitOpeningHour|null
     *
     * @version     2.0.0 / 2025-06-04
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getById(int|string $id, bool $ignoreCache = false, bool $returnOrFail = true): VisitOpeningHour|DerivedVisitOpeningHour|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->find($id);
        }
        return $cache[$cacheKey] = $Query->findOrFail($id);

    } // getById()


    /**
     * Liefert ein OpeningHour-Objekt für einen bestimmten Wochentag
     *
     * @param       int|string|VisitType|VisitTypeIdentifier $visitType
     *              Es kann wahlweise eine numerische ID, ein Identifier (als String oder als Enum) oder ein
     *              VisitType Model-Objekt übergeben werden.
     *
     * @param       int|null|string|WeekDay $weekday
     *              Die Nummer (0 = Sonntag, 1 = Montag, ...), der Name (Sunday, Monday, ...) eines
     *              Wochentags oder Alternativ eine Carbon\WeekDay-Instanz übergeben werden. Wenn kein
     *              Wert oder NULL übergeben wird, dann wird der aktuelle Wochentag verwendet.
     *
     * @param       bool $returnOrFail
     *              Steuert die Rückgabe der Methode.
     *              Wenn kein passender Eintrag in der Datenbank gefunden werden kann, dann wird entweder
     *              NULL zurückgegeben (TRUE) oder eine Exception geworfen (FALSE). So kann das Ergebnis
     *              des Methodenaufrufs direkt im Api-Controller verwendet werden.
     *
     * @return      null|VisitOpeningHour
     *
     * @version     1.0.0 / 2025-03-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getVisitTypeOpeningHoursByWeekday(int|string|VisitType|VisitTypeIdentifier $visitType, int|null|string|WeekDay $weekday = null, bool $returnOrFail = true): null|VisitOpeningHour
    {
        if ($visitType instanceof VisitType) {
            $visitTypeId = $visitType->id;

        } elseif (is_numeric($visitType)) {
            $visitTypeId = $visitType;

        } else {
            $VisitTypeIdentifier = $visitType;

            $VisitType = VisitTypeRepository::getByIdentifier($VisitTypeIdentifier);

            $visitTypeId = $VisitType->id;
        }
        if ($weekday === null) {
            $weekdayNumber = date('w');

        } elseif (is_numeric($weekday)) {
            $weekdayNumber = $weekday;

        } elseif ($weekday instanceof WeekDay) {
            $weekdayNumber = $weekday->value;

        } else {
            $weekdayNumber = WeekDay::{$weekday};
        }
        /*
        **  Öffnungszeiten zum übergebenen Wochentag ermitteln. */
        $Query = static::$_modelClass::where('visit_type_id', '=', $visitTypeId)
            ->where('weekday', '=', $weekdayNumber);

        if ($returnOrFail === true) {
            return $Query->first();
        }
        return $Query->firstOrFail();

    } // getVisitTypeOpeningHoursByWeekday()


} // class VisitOpeningHourRepository extends BaseRepository {}
